<?php
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../util.php";
    include "../costanti.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GeneratoreEmail.php";
    include "../classi/Utente.php";
    include "../classi/GeneratoreUrl.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    $impostazioni = recuperaImpostazioni($geecomDb);
    
    //dati utente
    $nome      = filter_input(INPUT_POST,"nome",FILTER_SANITIZE_STRING);
    $cognome   = filter_input(INPUT_POST,"cognome",FILTER_SANITIZE_STRING);
    $citta     = filter_input(INPUT_POST,"citta",FILTER_SANITIZE_STRING);
    $telefono  = filter_input(INPUT_POST,"telefono",FILTER_SANITIZE_STRING);
    $email     = strtolower(filter_input(INPUT_POST,"email",FILTER_SANITIZE_EMAIL));
    $password  = hash("sha512",filter_input(INPUT_POST,"password"));
    $passwordInChiaro = filter_input(INPUT_POST,"password");
    $organizzazione   = filter_input(INPUT_POST,"organizzazione",FILTER_SANITIZE_STRING);
    
    $queryControllo = "SELECT * FROM geec_utenti WHERE email LIKE '$email'";
    $result = $geecomDb->eseguiQueryLettura($queryControllo) or die($utenteDb->error);
    if($result->num_rows>0) {
        $impostazioni = recuperaImpostazioni($geecomDb);
        $pagina       = $geecomDb->leggiSingolaRiga("geecAd_contenuti", $impostazioni["paginaRegistrazione"]);
        $linkPagina   = GeneratoreUrl::creaUrlContenuto($pagina, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
        header("Location: $linkPagina&status=400");
        exit();
    }
    
    $utente = new Utente($geecomDb,0);
    
    $utente->setNome($nome);
    $utente->setCognome($cognome);
    $utente->setPassword($password);
    $utente->setEmail($email);
    $utente->setOrganizzazione($organizzazione);
    $utente->setTelefono($telefono);
    $utente->setCitta($citta);
    $utente->setRuolo("utente");
    $utente->setStato("attivato");
    $idUtente = $utente->crea();
    
    if($impostazioni["gruppoDefault"]!=0) {
        $queryAssociazioneGruppo ="INSERT INTO geec_gruppiUtenti VALUES(NULL,$idUtente,{$impostazioni["gruppoDefault"]});";
        $geecomDb->eseguiQueryScrittura($queryAssociazioneGruppo);
    }

    session_start();
    $_SESSION["geecomUser_id"] = $idUtente;
    $_SESSION["geecomUser_email"] = $email;
    $_SESSION["geecomUser_nomeCognome"] = $nome." ".$cognome;
    $_SESSION["geecomUser_nome"] = $nome;
    $_SESSION["geecomUser_foto"] = "immagini/altro/segnaPostoUtente.png";

    if(isset($_POST["gruppo"])) {
        $gruppoSelezionato = filter_input(INPUT_POST, "gruppo",FILTER_SANITIZE_NUMBER_INT);
        $queryAssociazioneGruppo ="INSERT INTO geec_gruppiUtenti VALUES(NULL,$idUtente,$gruppoSelezionato);";
        $geecomDb->eseguiQueryScrittura($queryAssociazioneGruppo);
        $_SESSION["geecomUser_gruppiUtente"] = array($gruppoSelezionato);
    }
    else {
         $_SESSION["geecomUser_gruppiUtente"] = array();
    }
    
    $datiModuloRegistrazione = $geecomDb->leggiSingolaRiga("geecAd_moduliRegistrazione", 1);
    $datiEmail = $geecomDb->leggiSingolaRiga("geec_templateEmail",1);
    
    //se ha creato l'utente invia una mail con i dati dell'account
    $generatoreEmail = new GeneratoreEmail($impostazioni["nomeMittente"], $impostazioni["emailMittente"]);
    
    $oggetto = "Creazione account";
    $link = $impostazioni['urlPiattaforma'];
    $messaggio = "Ciao $nome, <br> {$datiModuloRegistrazione["contenutoEmailRegistrazione"]}";
    
    if($datiModuloRegistrazione["inviaPasswordViaEmail"]=="si") {
        $messaggio .= "<br> La tua password è $passwordInChiaro";
    }
    
    $corpoMail = str_replace("___corpoTesto___",$messaggio,$datiEmail['corpoMail']);
    $html = "<!doctype html>
            <html>
              <head>
                <meta name=\"viewport\" content=\"width=device-width\" />
                <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
                <title>$oggetto</title>
                <style>
                    {$datiEmail['css']}
                </style>
              </head>
              <body class=\"\">
            </body>
            $corpoMail
            {$datiEmail['footerMail']}";
                    
    $htmlMail = str_replace("testo_da_inserire",$messaggio,$html);
    
    $generatoreEmail->invia($email, $oggetto, $htmlMail);
    
    if($impostazioni["paginaProfilo"]!=0) {
        $impostazioni = recuperaImpostazioni($geecomDb);
        $pagina       = $geecomDb->leggiSingolaRiga("geecAd_contenuti", $impostazioni["paginaProfilo"]);
        $linkPagina   = GeneratoreUrl::creaUrlContenuto($pagina, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
        header("Location: $linkPagina");
    }
    else {
        $impostazioni = recuperaImpostazioni($geecomDb);
        $pagina       = $geecomDb->leggiSingolaRiga("geecAd_contenuti", $impostazioni["homePage"]);
        $linkPagina   = GeneratoreUrl::creaUrlContenuto($pagina, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
        header("Location: $linkPagina");
    }
